;------------------------------------------------------------------------
; VivaNonno
; VivaNonno v22.0.3
; by djvj
; 1.0
;
; Notes:
; Roms must reside in the roms subdir of the emulator and be zipped. They must be built from the mame v0.112 romset, the current mame uses roms with a different crc
; Many of the emulator's settings are stored in settings.xml. This will only appear after you run a game. You can setup your analog controls here if you have any.
; Dat for roms can be found here: http://www.logiqx.com/Dats/OlderEmus/Older%20Emus%2020080420%20(xml).zip
;
; To use this in your MAME wheel:
; Add the <exe>VivaNonno </exe> tag to the supported game entries in your database
; Create a VivaNonno folder in your Modules folder and place this script in there. The name of this script must match the exe tag in your database
; Create a VivaNonno.ini in your Hyperspin\Settings folder. Open your MAME.ini in this folder and copy the [exe info] section into the VivaNonno.ini and change the "path" and "exe" to this emulator
;------------------------------------------------------------------------

Fullscreen = true
LoadingScreen = true
WinX = 0 ; For windowed mode only
WinY = 0

; This gets rid of the emu window that pops up on launch
If ( LoadingScreen = "true" ) {
		Gui +AlwaysOnTop -Caption +ToolWindow
		Gui Color, Black
		Gui Show, x0 y0 h%A_ScreenHeight% w%A_ScreenWidth%
	}

DetectHiddenWindows, off ; do not turn on

Run, %executable%, %emuPath%
WinWait, AHK_class ATL:004DB490
WinActivate, AHK_class ATL:004DB490
Send, {ALT}{ENTER 2} ; opening rom select
 
; Selecting the game we want to play
If ( romName = "rr1" ) ; Ridge Racer (Japan-A)
	SelectGame(1)
Else If ( romName = "rrs1" ) ; Ridge Racer 2 (Japan-A)
	SelectGame(2)
Else If ( romName = "rrs1b" ) ; Ridge Racer 2 (Japan-B)
	SelectGame(3)
Else If ( romName = "rv1" ) ; Rave Racer (Japan-A)
	SelectGame(4)
Else If ( romName = "rv1b" ) ; Rave Racer (Japan-B)
	SelectGame(5)
 Else If ( romName = "rv2" ) ; Rave Racer (World-B)
	SelectGame(6)

; Set Fullscreen
If ( Fullscreen = "true" )
	Send, !{ENTER}

Sleep, 2000 ; increase if black screen disappears before game starts
Gui Destroy

; In windowed mode on smaller resolutions, the game screen is might not be fully on screen and the emu doesn't save its last position. It doesn't take effect if you run fullscreen.
If ( Fullscreen != "true" )
	WinMove, AHK_class ATL:004DB490, , %WinX%, %WinY%

;(`._.`._.`._.`._.`._.`._.`._.)
; Remap your controls here (defaults are already provided), just place your key to the left of the :: and uncomment the line
; Example  to_key::from_key

; System Controls
; ::t			; Service Menu

; Player 1 Controls
; ::Up		; Shift Up
; ::Down	; Shift Down
; ::Left		; Steer Left
; ::Right	; Steer Right
; ::c			; Gas Pedal
; ::x			; Brake Pedal
; ::v			; VIEW Switch (Rave Racer Only)
; ::s			; Pause
; ::q			; Coin (also serves as Service Switch)
;(_.`._.`._.`._.`._.`._.`._.`._)

Process, WaitClose, %executable%

ExitApp

SelectGame(var){
		Control, Choose, %var%, ListBox1, AHK_class #32770
	}
	
CloseProcess:
return